package net.spyman.basicmachines.common.containers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;

public class ContainerBase extends Container
{
    public InventoryPlayer pinv;
    public int rows;

    public ContainerBase(InventoryPlayer inv)
    {
        this.pinv = inv;
        this.bindPlayerInventory();
    }

    public void bindPlayerInventory()
    {
        this.rows = this.pinv.getSizeInventory() / 9;
        int i = (this.rows - 4) * 18;

        for (int j = 0; j < 3; ++j)
        {
            for (int k = 0; k < 9; ++k)
            {
                this.addSlotToContainer(new Slot(this.pinv, k + j * 9 + 9, 8 + k * 18, 103 + j * 18 + i));
            }
        }

        for (int j = 0; j < 9; ++j)
        {
            this.addSlotToContainer(new Slot(this.pinv, j, 8 + j * 18, 161 + i));
        }
    }

    public InventoryPlayer getPlayerInv()
    {
        return this.pinv;
    }

    @Override
    public boolean canInteractWith(EntityPlayer playerIn)
    {
        return true;
    }
}
