package net.spyman.basicmachines.common.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.spyman.basicmachines.common.BasicMachines;

public class BlockBase extends Block
{
    private String name;
    private Item itemBlock;

    public BlockBase(Material mat, String name)
    {
        super(mat);
        this.setUnlocalizedName(name);
        this.setRegistryName(name);
        this.setCreativeTab(BasicMachines.BM_TAB);
        this.name = name;
        this.itemBlock = new ItemBlock(this);
        this.itemBlock.setRegistryName(name);
        MinecraftForge.EVENT_BUS.register(this);
    }

    @SubscribeEvent
    public void registerItem(RegistryEvent.Register<Item> event)
    {
        event.getRegistry().register(this.itemBlock);
    }

    @SubscribeEvent
    public void registerBlock(RegistryEvent.Register<Block> event)
    {
        event.getRegistry().register(this);
    }

    @SubscribeEvent
    public void registerModel(ModelRegistryEvent event)
    {
        ModelLoader.setCustomModelResourceLocation(this.itemBlock, 0, new ModelResourceLocation(BasicMachines.RPREFIX + this.name));
    }

    public ItemBlock getItemBlock()
    {
        return (ItemBlock) this.itemBlock;
    }
}
