package net.spyman.basicmachines.common;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.spyman.basicmachines.client.render.RenderEntityQuarryMiner;
import net.spyman.basicmachines.common.blocks.BMBlocks;
import net.spyman.basicmachines.common.entity.EntityQuarryMiner;
import net.spyman.basicmachines.common.items.BMItems;

@Mod(modid = "basicmachines", name = "BasicMachines", version = "1.0")
public class BasicMachines
{
    // Mod id field
    public static final String MODID = "basicmachines";
    // Mod id + ':' field for resource location prefix
    public static final String RPREFIX = MODID + ":";
    // Insatance field;
    @Mod.Instance("basicmachines")
    public static BasicMachines instance;

    // Creative tab
    public static CreativeTabs BM_TAB = new CreativeTabs("bm_tab")
    {
        @Override
        public ItemStack getTabIconItem()
        {
            return new ItemStack(BMBlocks.BLOCK_QUARRY);
        }
    };

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event)
    {
        new BMBlocks();
        new BMItems();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event)
    {
        EntityRegistry.registerModEntity(new ResourceLocation("basicmachines:entity_quarry_miner"), EntityQuarryMiner.class, "entity_quarry_miner", 0, this, 0, 1, false);

        if (event.getSide().isClient())
            RenderingRegistry.registerEntityRenderingHandler(EntityQuarryMiner.class, new RenderEntityQuarryMiner());

        NetworkRegistry.INSTANCE.registerGuiHandler(this, new BMGuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event)
    {

    }
}
