package net.spyman.basicmachines.common;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.spyman.basicmachines.client.gui.GuiBlockQuarry;
import net.spyman.basicmachines.common.blocks.tileentity.TEBlockQuarry;
import net.spyman.basicmachines.common.containers.ContainerBlockQuarry;

public class BMGuiHandler implements IGuiHandler
{
    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
    {
        TileEntity tile = world.getTileEntity(new BlockPos(x ,y ,z));

        if (tile instanceof TEBlockQuarry)
            return new ContainerBlockQuarry(player.inventory);

        return null;
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
    {
        TileEntity tile = world.getTileEntity(new BlockPos(x ,y ,z));

        if (tile instanceof TEBlockQuarry)
            return new GuiBlockQuarry((TEBlockQuarry) tile, new ContainerBlockQuarry(player.inventory));

        return null;
    }
}
