package net.spyman.basicmachines.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderEntity;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.spyman.basicmachines.client.models.ModelQuarryMiner;
import net.spyman.basicmachines.common.BasicMachines;

public class RenderEntityQuarryMiner extends RenderEntity
{
    private ModelQuarryMiner modelQuarryMiner = new ModelQuarryMiner();
    private ResourceLocation texture = new ResourceLocation(BasicMachines.RPREFIX + "textures/entities/tmap_model_quarryminer.png");

    public RenderEntityQuarryMiner()
    {
        super(Minecraft.getMinecraft().getRenderManager());
    }

    @Override
    public void doRender(Entity entity, double x, double y, double z, float entityYaw, float partialTicks)
    {
        this.bindTexture(texture);
        this.modelQuarryMiner.render(entity, (float)x, (float)y, (float)z, (float)entityYaw, (float)partialTicks, 1.0F);
        super.doRender(entity, x, y, z, entityYaw, partialTicks);
    }

    @Override
    protected ResourceLocation getEntityTexture(Entity entity)
    {
        return this.texture;
    }
}
