package net.spyman.basicmachines.common.packet;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageBlockQuarry implements IMessage
{
    private String value = "false";

    public MessageBlockQuarry(String v)
    {
        this.value = v;
    }

    @Override
    public void fromBytes(ByteBuf buf)
    {
        this.value = ByteBufUtils.readUTF8String(buf);
    }

    @Override
    public void toBytes(ByteBuf buf)
    {
        ByteBufUtils.writeUTF8String(buf, this.value);
    }

    public static class Handler implements IMessageHandler<MessageBlockQuarry, IMessage>
    {
        @Override
        public IMessage onMessage(MessageBlockQuarry message, MessageContext ctx)
        {
            System.out.println(message.value);
            return null;
        }
    }
}
