package net.spyman.basicmachines.common.blocks;

import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.spyman.basicmachines.common.BasicMachines;
import net.spyman.basicmachines.common.blocks.tileentities.TEBlockQuarry;
import net.spyman.basicmachines.core.blocks.BlockOrientable;
import net.spyman.basicmachines.core.blocks.IWrenchable;

public class BlockQuarry extends BlockOrientable implements IWrenchable, ITileEntityProvider
{
    public BlockQuarry(String name)
    {
        super(Material.IRON, name);
    }

    @Override
    public boolean hasTileEntity(IBlockState s)
    {
        return true;
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta)
    {
        return new TEBlockQuarry();
    }

    @Override
    public boolean onBlockActivated(World w, BlockPos pos, IBlockState state, EntityPlayer p, EnumHand h, EnumFacing f, float hitX, float hitY, float hitZ)
    {
        p.openGui(BasicMachines.instance, 1, w, pos.getX(), pos.getY(), pos.getZ());
        return true;
    }
}
