package net.spyman.basicmachines.common;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.spyman.basicmachines.client.events.ClientEventHandler;
import net.spyman.basicmachines.common.blocks.BMBlocks;
import net.spyman.basicmachines.common.items.BMItems;
import net.spyman.basicmachines.common.packet.MessageBlockQuarry;

@Mod(modid = "basicmachines", name = "BasicMachines", version = "1.0")
public class BasicMachines
{
    // Mod id field
    public static final String MODID = "basicmachines";
    // Mod id + ':' field for resource location prefix
    public static final String RPREFIX = MODID + ":";
    // Insatance field;
    @Mod.Instance("basicmachines")
    public static BasicMachines instance;
    // Network packets field
    public static SimpleNetworkWrapper network;

    // Creative tab
    public static CreativeTabs BM_TAB = new CreativeTabs("bm_tab")
    {
        @Override
        public ItemStack getTabIconItem()
        {
            return new ItemStack(BMBlocks.BLOCK_QUARRY);
        }
    };

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event)
    {
        new BMBlocks();
        new BMItems();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event)
    {
        NetworkRegistry.INSTANCE.registerGuiHandler(this, new BMGuiHandler());

        if (event.getSide().isClient())
        {
            MinecraftForge.EVENT_BUS.register(new ClientEventHandler());
        }

        network = NetworkRegistry.INSTANCE.newSimpleChannel(RPREFIX + "channel1");
        network.registerMessage(MessageBlockQuarry.Handler.class, MessageBlockQuarry.class, 0, Side.SERVER);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event)
    {

    }
}
