package net.spyman.basicmachines.client.gui.components;

import com.mojang.realmsclient.gui.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL11;

public class GuiSwitchButton extends GuiButton
{
    private boolean switched = false;

    public GuiSwitchButton(int id, int x, int y, String text)
    {
        super(id, x, y, text);
    }

    public GuiSwitchButton(int id, int x, int y, int width, int height, String text)
    {
        super(id, x, y, width, height, text);
    }

    public GuiSwitchButton(int id, int x, int y, int width, int height, String text, boolean state)
    {
        super(id, x, y, width, height, text);
        this.switched = state;
    }

    @Override
    public void drawButton(Minecraft mc, int mx, int my, float partialTicks)
    {
        if (this.visible)
        {
            FontRenderer fontrenderer = mc.fontRenderer;
            mc.getTextureManager().bindTexture(BUTTON_TEXTURES);
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
            this.hovered = mx >= this.x && my >= this.y && mx < this.x + this.width && my < this.y + this.height;
            int k = this.getHoverState(this.hovered);
            GL11.glEnable(GL11.GL_BLEND);
            OpenGlHelper.glBlendFunc(770, 771, 1, 0);
            GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
            this.drawTexturedModalRect(this.x, this.y, 0, 46 + k * 20, this.width / 2, this.height);
            this.drawTexturedModalRect(this.x + this.width / 2, this.y, 200 - this.width / 2, 46 + k * 20, this.width / 2, this.height);
            this.mouseDragged(mc, mx, my);
            int l = 14737632;

            if (packedFGColour != 0)
                l = packedFGColour;
            else if (!this.enabled)
                l = 10526880;
            else if (this.hovered)
                l = 16777120;

            if (this.switched)
                this.drawCenteredString(fontrenderer, ChatFormatting.GREEN + this.displayString + " : On", this.x + this.width / 2, this.y + (this.height - 8) / 2, l);
            else
                this.drawCenteredString(fontrenderer, ChatFormatting.RED + this.displayString + " : Off", this.x + this.width / 2, this.y + (this.height - 8) / 2, l);
        }
    }

    @Override
    public boolean mousePressed(Minecraft mc, int i, int j)
    {
        boolean isPressed = super.mousePressed(mc, i, j);

        if (isPressed)
            this.swap();

        return isPressed;
    }

    public boolean getState()
    {
        return this.switched;
    }

    public void setState(boolean switched)
    {
        this.switched = switched;
    }

    public boolean swap()
    {
        this.switched = !this.switched;
        return this.switched;
    }
}