package net.spyman.basicmachines.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.spyman.basicmachines.client.gui.components.GuiSwitchButton;
import net.spyman.basicmachines.common.BasicMachines;
import net.spyman.basicmachines.common.blocks.tileentities.TEBlockQuarry;
import net.spyman.basicmachines.common.containers.ContainerBlockQuarry;
import net.spyman.basicmachines.common.packet.MessageBlockQuarry;

import java.awt.*;
import java.io.IOException;

public class GuiBlockQuarry extends GuiContainer
{
    private final ResourceLocation texture = new ResourceLocation(BasicMachines.RPREFIX + "textures/gui/container/gui_quarry.png");
    private TEBlockQuarry tile;

    private String title = I18n.format("gui.block_quarry.title");
    private int x = 0;
    private int y = 0;
    private int bh = 7;
    private int bw = 15;
    private int color = new Color(21, 21, 21).getRGB();
    private GuiSwitchButton switchButton;
    /* **** AREA BOUNDS **** */
    private int sx = 0;
    private int sy = 0;
    private int sz = 0;
    /* **** AREA BOUNDS **** */
    private boolean isActive = false;
    private ContainerBlockQuarry container;

    public GuiBlockQuarry(TEBlockQuarry tile, ContainerBlockQuarry container)
    {
        super(container);
        this.container = container;
        this.tile = tile;
        this.xSize = 176;
        this.ySize = 199;
        this.sx = tile.getSizeX();
        this.sy = tile.getStopY();
        this.sz = tile.getSizeZ();
        this.isActive = tile.isActivated();
    }

    @Override
    public void initGui()
    {
        this.x = (this.width - this.xSize) / 2;
        this.y = (this.height - this.ySize) / 2;

        this.switchButton = new GuiSwitchButton(6, (4 + x + 20 + 10 * 5) + 23, y + 81, 65, 20, I18n.format("gui.block_quarry.button.activated", this.isActive));

        this.addButton(new GuiButton(0, 4 + x + 10,          10 + y + 50 + 15, this.bw, this.bh, "+"));
        this.addButton(new GuiButton(1, 4 + x + 10,               y + 100, this.bw, this.bh, "-"));
        this.addButton(new GuiButton(2, 4 + x + 10 + 10 * 3, 10 + y + 50 + 15, this.bw, this.bh, "+"));
        this.addButton(new GuiButton(3, 4 + x + 10 + 10 * 3,      y + 100, this.bw, this.bh, "-"));
        this.addButton(new GuiButton(4, 4 + x + 20 + 10 * 5, 10 + y + 50 + 15, this.bw, this.bh, "+"));
        this.addButton(new GuiButton(5, 4 + x + 20 + 10 * 5,      y + 100, this.bw, this.bh, "-"));
        this.addButton(this.switchButton); // ID = 6
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY)
    {
        GlStateManager.color(1.0F, 1.0F, 1.0F, 1.0F);
        this.mc.getTextureManager().bindTexture(this.texture);
        this.drawTexturedModalRect(this.x, this.y, 0, 0, this.xSize, this.ySize);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY)
    {
        this.mc.fontRenderer.drawString(this.title, (float)(this.width - this.mc.fontRenderer.getStringWidth(this.title)) / 2, (float)this.y + 9, this.color, false);
        this.mc.fontRenderer.drawString(" X      Y      Z", x + 13, y + 62, this.color, false);
        this.mc.fontRenderer.drawString(this.sx + "", (float)5 +x + 10,          (float)12 + y + this.bh + 4 + 50 + 15, this.color, false);
        this.mc.fontRenderer.drawString(this.sy + "", (float)5 + x + 10 + 10 * 3, (float)12 + y + this.bh + 4 + 50 + 15, this.color, false);
        this.mc.fontRenderer.drawString(this.sz + "", (float)5 + x + 20 + 10 * 5, (float)12 + y + this.bh + 4 + 50 + 15, this.color, false);
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException
    {
        super.actionPerformed(button);

        if (button.id == 0) this.sx++;
        if (button.id == 1) this.sx--;
        if (button.id == 2) this.sy++;
        if (button.id == 3) this.sy--;
        if (button.id == 4) this.sz++;
        if (button.id == 5) this.sz--;

        if (button.id == 6)
        {
            this.tile.setActivated(this.switchButton.getState());
            BasicMachines.network.sendToServer(new MessageBlockQuarry(this.switchButton.getState() + ""));
        }

        if (this.sx < 0) this.sx = 0;
        if (this.sy < 0) this.sy = 0;
        if (this.sz < 0) this.sz = 0;

        this.tile.setAreaBounds(this.sx, this.sz, this.sy);
    }
}
