package net.spyman.basicmachines.core.items;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.spyman.basicmachines.common.BasicMachines;

public class ItemBase extends Item
{
    private String name;

    public ItemBase(String name)
    {
        this.setUnlocalizedName(name);
        this.setCreativeTab(BasicMachines.BM_TAB);
        this.setRegistryName(name);
        this.name = name;
        MinecraftForge.EVENT_BUS.register(this);
    }

    @SubscribeEvent
    public void registerItem(RegistryEvent.Register<Item> event)
    {
        event.getRegistry().register(this);
    }

    @SubscribeEvent
    public void registerModel(final ModelRegistryEvent event)
    {
        ModelLoader.setCustomModelResourceLocation(this, 0, new ModelResourceLocation(BasicMachines.RPREFIX + this.name));
    }

    public String getName()
    {
        return this.name;
    }
}
