package net.spyman.basicmachines.common.items;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.spyman.basicmachines.core.blocks.IWrenchable;
import net.spyman.basicmachines.core.items.ItemBase;

public class ItemWrench extends ItemBase
{
    public ItemWrench(String name)
    {
        super(name);
    }

    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer p, World w, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand)
    {
        if (!w.isRemote)
        {
            if (p.isSneaking())
            {
                if (hand == EnumHand.MAIN_HAND)
                {
                    Block b = w.getBlockState(pos).getBlock();

                    if (b instanceof IWrenchable)
                    {
                        b.breakBlock(w, pos, b.getDefaultState());
                        b.dropBlockAsItem(w, pos, b.getDefaultState(), 0);
                        w.setBlockToAir(pos);
                        return EnumActionResult.SUCCESS;
                    }
                    else
                        return EnumActionResult.FAIL;
                }
            }
        }
        return EnumActionResult.FAIL;
    }
}
