package net.spyman.basicmachines.client.events;

import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.spyman.basicmachines.client.utils.GfxHelper;
import net.spyman.basicmachines.common.BasicMachines;
import net.spyman.basicmachines.core.blocks.ITooltipable;

import java.awt.*;

@SideOnly(Side.CLIENT)
public class ClientEventHandler
{
    @SubscribeEvent
    public void onRanderGameOverlay(RenderGameOverlayEvent.Post event)
    {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CHAT)
        {
            this.renderTooltip();
        }
    }

    private void renderTooltip()
    {
        BlockPos pos = Minecraft.getMinecraft().player.rayTrace(5, 2f).getBlockPos();
        World w0 = Minecraft.getMinecraft().player.world;

        if (w0.getTileEntity(pos) instanceof ITooltipable)
        {
            ITooltipable it = (ITooltipable) w0.getTileEntity(pos);
            int sw = Minecraft.getMinecraft().fontRenderer.getStringWidth(it.getTooltipInfo());
            int sh = Minecraft.getMinecraft().fontRenderer.FONT_HEIGHT - 4;
            ResourceLocation loc = new ResourceLocation(BasicMachines.RPREFIX + "textures/gui/gui_comp.png");
            int th = 30;
            int x = 5;
            int y = 5;
            int s = 7;
            int w = sw + (s * 2);
            int v1 = w + s;

            GfxHelper.drawTexturedModalRect(x, y, 0, 0, 2, th, loc);

            for (int i = 2; i < v1; i += 2)
            {
                GfxHelper.drawTexturedModalRect(x + i, y, 4, 0, 2, th, loc);
            }

            GfxHelper.drawTexturedModalRect(x + sw + s + 2 + 13, y, 0, 0, 2, th, loc);

            int sx = ((x + s + (w - sw)) / 2) + 4;
            int sy = (y + (th - sh) / 2) - 1;

            GfxHelper.drawString(it.getTooltipInfo(), sx, sy, Color.BLACK.getRGB());
        }
    }
}
