package com.CSC.net.save;

import java.util.Iterator;
import java.util.UUID;
import java.util.Map.Entry;

import javafx.geometry.Pos;

import com.CSC.net.Events.Events;
import com.CSC.net.Events.Events.Position;
import com.CSC.net.properties.EnumRank;
import com.CSC.net.proxy.ServerProxy;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.DimensionManager;

public class WorldSaved extends WorldSavedData
{
    public static WorldSaved instance;

    public static WorldSaved load()
    {
        if(DimensionManager.getWorlds().length < 1)
        {
            return null;
        }

        MapStorage storage = DimensionManager.getWorlds()[0].getMapStorage(); // On récupère la mapStorage de la dimension
        final String KEY = Events.Key; // Si vous avez choisis de faire une fonction static String. Quoiqu'il en soit, la variable KEY que nous utiliserons ici représente votre clé. Si vous
                                       // utilisez un attribut static, utilisez le directement.
        WorldSaved result = (WorldSaved)storage.loadData(WorldSaved.class, KEY);// On charge nos donn�es
        if(result == null)
        { // Si nos données n'existe pas, ...
            result = new WorldSaved(KEY);// Alors on les créé ...
            storage.setData(KEY, result);// Et on les ajoutes à la mapStorage.
        }

        return result;

    }

    public WorldSaved(String key)
    {
        super(key);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound)
    {
        System.out.println("test read");
        NBTTagList keyList = (NBTTagList)compound.getTag("keyList");
        for(int i = 0; i < keyList.tagCount(); i++)
        {
            NBTTagCompound keyTag = keyList.getCompoundTagAt(i);
            Events.doorsPositions.add(new Position(keyTag.getInteger("x"), keyTag.getInteger("y"), keyTag.getInteger("z"), keyTag.getInteger("dimension")));
        }
        for(int i = 0; i < keyList.tagCount(); i++)
        {
            NBTTagCompound keyTag = keyList.getCompoundTagAt(i);
            try
            {
                UUID uuid = UUID.fromString(keyTag.getString("uuid"));
                ServerProxy.map.put(uuid, keyTag.getString("name"));
            }
            catch(Throwable err)
            {
                System.err.println("Error with tag : " + keyTag.getString("uuid"));
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound)
    {
        NBTTagList keyList = new NBTTagList();
        Iterator<Position> iterator = Events.doorsPositions.iterator();
        Position pos;
        NBTTagCompound keyTag = new NBTTagCompound();
        while(iterator.hasNext())
        {
            pos = iterator.next();
            keyTag.setInteger("x", pos.getX());
            keyTag.setInteger("y", pos.getY());
            keyTag.setInteger("z", pos.getZ());
            keyTag.setInteger("dimension", pos.dimensionId);
            keyList.appendTag(keyTag);
        }
        
        Iterator<Entry<UUID, String>> iterator2 = ServerProxy.map.entrySet().iterator();
        while(iterator2.hasNext())
        {
            Entry<UUID, String> entry = iterator2.next();
            keyTag.setString("uuid", entry.getKey().toString());
            keyTag.setString("name", entry.getValue());
            keyList.appendTag(keyTag);
        }
        compound.setTag("keyList", keyList);
    }
}
