package com.CSC.net.proxy;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import net.minecraft.nbt.NBTTagCompound;

import com.CSC.net.block.CSCBlocks;
import com.CSC.net.item.CSCItems;

public class CommonProxy
{

    private static final Map<String, NBTTagCompound> extendedEntityData = new HashMap<String, NBTTagCompound>();

    public void preInit(File configFile)
    {
        CSCItems.registerItems();
        CSCBlocks.registerBlock();
    }

    public void init()
    {

    }

    public static void storeEntityData(String name, NBTTagCompound compound)
    {
        extendedEntityData.put(name, compound);
    }

    public static NBTTagCompound getEntityData(String name)
    {
        return extendedEntityData.remove(name);
    }

}
