package com.CSC.net.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSounds implements IMessage
{

    private Integer integer;

    public PacketSounds()
    {

    }

    public PacketSounds(Integer i)
    {
        this.integer = i;
    }

    @Override
    public void fromBytes(ByteBuf buf)
    {
        this.integer = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf)
    {
        buf.writeInt(this.integer);
    }

    public static class Handler implements IMessageHandler<PacketSounds, IMessage>
    {
        @SideOnly(Side.CLIENT)
        @Override
        public IMessage onMessage(PacketSounds message, MessageContext ctx)
        {
            switch(message.integer)
            {
                case 0:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:10-97"), 1.0F));
                    break;
                case 1:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:administrer"), 1.0F));
                    break;
                case 2:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:affirmatif"), 1.0F));
                    break;
                case 3:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:ahahah"), 1.0F));
                    break;
                case 4:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:anti_citoyen"), 1.0F));
                    break;
                case 5:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:appliquez"), 1.0F));
                    break;
                case 6:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:arretez_tout_de_suite"), 1.0F));// arretez
                    break;
                case 7:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:avancez"), 1.0F));
                    break;
                case 8:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:bloquez"), 1.0F));
                    break;
                case 9:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:bougez"), 1.0F));
                    break;
                case 10:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:circulez2"), 1.0F));// circulez2
                    break;
                case 11:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:citoyen"), 1.0F));
                    break;
                case 12:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:classez_le_sujet_comme_d_c_d_wa"), 1.0F));// dcd
                    break;
                case 13:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:code100"), 1.0F));
                    break;
                case 14:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:confirmation_sur_le_suspect_10-0"), 1.0F));// confirmedata
                    break;
                case 15:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:continuez"), 1.0F));
                    break;
                case 16:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:dernier_avertissement"), 1.0F));
                    break;
                case 17:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:deuxi_me_avertissement_"), 1.0F));
                    break;
                case 18:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:documentez"), 1.0F));
                    break;
                case 19:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:emput_"), 1.0F));// emputez
                    break;
                case 20:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:examinez"), 1.0F));
                    break;
                case 21:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:f_anticitizenreport_spkr"), 1.0F));// Attendre darkmayke
                    break;
                case 22:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:f_anticivil1_5_spkr"), 1.0F));// Attendre darkmayke
                    break;
                case 23:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:f_anticivilevidence_3_spkr"), 1.0F));// Attendre darkmayke
                    break;
                case 24:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:f_capitalmalcompliance_spkr"), 1.0F));// Attendre darkmayke
                    break;
                case 25:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:f_citizenshiprevoked_6_spkr"), 1.0F));// Attendre darkmayke
                    break;
                case 26:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:f_protectionresponse_1_spkr"), 1.0F));// Attendre darkmayke
                    break;
                case 27:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:f_trainstation_assemble_spkr"), 1.0F));// Attendre darkmayke
                    break;
                case 28:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:f_trainstation_assumepositions_spkr"), 1.0F));// Attendre darkmayke
                    break;
                case 29:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:f_trainstation_offworldrelocation_spkr"), 1.0F));// Attendre darkmayke
                    break;
                case 30:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:grenade"), 1.0F));
                    break;
                case 31:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:hostil"), 1.0F));
                    break;
                case 32:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:insecte"), 1.0F));
                    break;
                case 33:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:isolez"), 1.0F));
                    break;
                case 34:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:j_39_ai_dis_circulez"), 1.0F));// circulez3
                    break;
                case 35:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:Milice"), 1.0F));
                    break;
                case 36:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:mort"), 1.0F));
                    break;
                case 37:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:moveit2"), 1.0F));// ne pas mettre
                    break;
                case 38:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:OKAY"), 1.0F));
                    break;
                case 39:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:okay_nous_allons_faire_un_test_de_loyaut_"), 1.0F));// test_loyaute
                    break;
                case 40:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:pas_un_geste"), 1.0F));
                    break;
                case 41:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:passage_en_mod_visuel"), 1.0F));// visuel
                    break;
                case 42:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:passif"), 1.0F));
                    break;
                case 43:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:poursuivez"), 1.0F));
                    break;
                case 44:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:pr_t_emputer_w"), 1.0F));// pret_emputez
                    break;
                case 45:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:premier_avertissement_d_gagez_"), 1.0F));// avt1
                    break;
                case 46:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:re_u_"), 1.0F));// recu
                    break;
                case 47:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:reculez"), 1.0F));
                    break;
                case 48:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:reculez_tout_de_suite"), 1.0F));// reculez2
                    break;
                case 49:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:refus_d_39_optemp_rer_en_cours_"), 1.0F));// refus_optemperer
                    break;
                case 50:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:rois"), 1.0F));
                    break;
                case 51:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:st_rilisez_"), 1.0F));// sterilisez
                    break;
                case 52:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:stop"), 1.0F));// stop1
                    break;
                case 53:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:sujet_505"), 1.0F));// 505
                    break;
                case 54:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:tr_s_bien_circulez_"), 1.0F));// circulez1
                    break;
                case 55:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:union"), 1.0F));
                    break;
                case 56:
                    Minecraft.getMinecraft().getSoundHandler().playSound(PositionedSoundRecord.create(new ResourceLocation("csc:vite"), 1.0F));
                    break;
                default:
                    break;
            }
            return null;

        }
    }

}
