package com.CSC.net.packet;

import com.CSC.net.proxy.ServerProxy;
import com.CSC.net.save.WorldSaved;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketNameServerAdd implements IMessage
{

    private String displayName;


    public PacketNameServerAdd(String name)
    {
        this.displayName = name;
    }

    public PacketNameServerAdd()
    {}

    @Override
    public void fromBytes(ByteBuf buf)
    {
        this.displayName = ByteBufUtils.readUTF8String(buf);
    }

    @Override
    public void toBytes(ByteBuf buf)
    {
        ByteBufUtils.writeUTF8String(buf, displayName);
    }

    public static class Handler implements IMessageHandler<PacketNameServerAdd, IMessage>
    {
        @Override
        public IMessage onMessage(PacketNameServerAdd message, MessageContext ctx)
        {
            ServerProxy.map.put(ctx.getServerHandler().playerEntity.getGameProfile().getId(), message.displayName);
            WorldSaved.instance.markDirty();
            ctx.getServerHandler().playerEntity.refreshDisplayName();
            return null;
        }
    }
}