package com.CSC.net.packet;

import com.CSC.net.proxy.ServerProxy;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketNameClient implements IMessage
{

    private String string;

    public PacketNameClient(String s)
    {
        this.string = s;
    }

    public PacketNameClient()
    {

    }

    @Override
    public void fromBytes(ByteBuf buf)
    {
        this.string = ByteBufUtils.readUTF8String(buf);
    }

    @Override
    public void toBytes(ByteBuf buf)
    {
        ByteBufUtils.writeUTF8String(buf, string);
    }

    public static class Handler implements IMessageHandler<PacketNameClient, IMessage>
    {
        @SideOnly(Side.CLIENT)
        @Override
        public IMessage onMessage(PacketNameClient message, MessageContext ctx)
        {

            System.out.println(message.string);

            return null;

        }
    }

}
