package com.CSC.net.block;

import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class block1 extends Block
{

    protected block1(Material materialIn)
    {
        super(materialIn);
        this.setTickRandomly(true);
    }

    public int tickRate(World worldIn)
    {
        return 900 * 20;// 900
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand)
    {
        world.scheduleUpdate(pos, this, this.tickRate(world));
        world.setBlockState(new BlockPos(pos.getX(), pos.getY(), pos.getZ()), CSCBlocks.block_sale.getDefaultState());

        if(world.rand.nextInt(4) == 0) // une chance sur 4
        {
            world.setBlockState(new BlockPos(pos.getX(), pos.getY() + 1, pos.getZ()), Blocks.anvil.getDefaultState());
        }
    }

    public void onBlockAdded(World worldIn, BlockPos pos, IBlockState state)
    {
        worldIn.scheduleUpdate(pos, this, this.tickRate(worldIn));
    }

}
