package com.CSC.net.block;

import com.CSC.net.item.CSCItems;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;

public class TileEntityCuve extends TileEntity implements IInventory, ITickable
{
    private ItemStack[] inventory = new ItemStack[72];
    private String customName;
    int timer = 600 * 20;

    public void readFromNBT(NBTTagCompound nbttag)
    {
        super.readFromNBT(nbttag);
        NBTTagList nbttaglist = nbttag.getTagList("Items", 10);
        this.inventory = new ItemStack[this.getSizeInventory()];

        if(nbttag.hasKey("CustomName"))
        {
            this.customName = nbttag.getString("CustomName");
        }

        for(int i = 0; i < nbttaglist.tagCount(); i++)
        {
            NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
            int j = nbttagcompound1.getByte("Slot");

            if(j >= 0 && j < this.inventory.length)
            {
                this.inventory[j] = ItemStack.loadItemStackFromNBT(nbttagcompound1);
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbttag)
    {
        super.writeToNBT(nbttag);
        NBTTagList nbttaglist = new NBTTagList();

        for(int i = 0; i < this.inventory.length; i++)
        {
            if(this.inventory[i] != null)
            {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)i);
                this.inventory[i].writeToNBT(nbttagcompound1);
                nbttaglist.appendTag(nbttagcompound1);
            }
        }

        nbttag.setTag("Items", nbttaglist);

        if(this.isInvNameLocalized())
        {
            nbttag.setString("CustomName", this.customName);
        }
    }

    @Override
    public int getSizeInventory()
    {
        return inventory.length;
    }

    @Override
    public ItemStack getStackInSlot(int slotId)
    {
        return inventory[slotId];
    }

    @Override
    public ItemStack decrStackSize(int slotId, int quantity)
    {
        if(this.inventory[slotId] != null)
        {
            ItemStack itemstack;

            if(this.inventory[slotId].stackSize <= quantity)
            {
                itemstack = this.inventory[slotId];
                this.inventory[slotId] = null;
                this.markDirty();
                return itemstack;
            }
            else
            {
                itemstack = this.inventory[slotId].splitStack(quantity);

                if(this.inventory[slotId].stackSize == 0)
                {
                    this.inventory[slotId] = null;
                }

                this.markDirty();
                return itemstack;
            }
        }
        else
        {
            return null;
        }
    }

    @Override
    public ItemStack removeStackFromSlot(int slotId)
    {
        if(this.inventory[slotId] != null)
        {
            ItemStack itemstack = this.inventory[slotId];
            this.inventory[slotId] = null;
            return itemstack;
        }
        else
        {
            return null;
        }
    }

    @Override
    public void setInventorySlotContents(int slotId, ItemStack stack)
    {
        this.inventory[slotId] = stack;

        if(stack != null && stack.stackSize > this.getInventoryStackLimit())
        {
            stack.stackSize = this.getInventoryStackLimit();
        }

        this.markDirty();
    }

    @Override
    public int getInventoryStackLimit()
    {
        // TODO Auto-generated method stub
        return 64;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player)
    {
        return this.worldObj.getTileEntity(this.pos) != this ? false : player.getDistanceSq((double)this.pos.getX() + 0.5D, (double)this.pos.getY() + 0.5D, (double)this.pos.getZ() + 0.5D) <= 64.0D;
    }

    @Override
    public void openInventory(EntityPlayer player)
    {
        // TODO Auto-generated method stub

    }

    @Override
    public void closeInventory(EntityPlayer player)
    {
        // TODO Auto-generated method stub

    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack stack)
    {
        return true;
    }

    @Override
    public int getField(int id)
    {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public void setField(int id, int value)
    {
        // TODO Auto-generated method stub

    }

    @Override
    public int getFieldCount()
    {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public void clear()
    {
        // TODO Auto-generated method stub

    }

    @Override
    public String getName()
    {
        return this.isInvNameLocalized() ? this.customName : "container.bigchest";
    }

    public boolean isInvNameLocalized()
    {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomGuiName(String name)
    {
        this.customName = name;
    }

    @Override
    public IChatComponent getDisplayName()
    {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean hasCustomName()
    {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public void update()
    {
        if(timer <= 0)
        {
            for(int i = 0; i < getSizeInventory(); i++)
            {

                setInventorySlotContents(i, new ItemStack(CSCItems.linge_sale));
                timer = 600 * 20;
            }

        }
        else
        {
            timer--;
        }
    }

}
