package com.CSC.net.block;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import com.CSC.net.item.CSCItems;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class RecipesSecheLinge
{

    private static final RecipesSecheLinge INSTANCE = new RecipesSecheLinge();
    private Map<ItemStack[], ItemStack[]> inputToOutput = new HashMap<ItemStack[], ItemStack[]>();
    private Map<ItemStack, Integer> fuelToTime = new HashMap<ItemStack, Integer>();

    public static RecipesSecheLinge instance()
    {
        return INSTANCE;
    }

    private RecipesSecheLinge()
    {
        this.addFuel(new ItemStack(CSCItems.lingette), 1000);

        this.addRecipe(new ItemStack[] {new ItemStack(CSCItems.linge_propre_mouiller), new ItemStack(CSCItems.linge_propre_mouiller), new ItemStack(CSCItems.linge_propre_mouiller), new ItemStack(CSCItems.linge_propre_mouiller)}, new ItemStack[] {new ItemStack(CSCItems.linge_propre_sec), new ItemStack(CSCItems.linge_propre_sec), new ItemStack(CSCItems.linge_propre_sec), new ItemStack(CSCItems.linge_propre_sec)});
    }

    public int getFuelDuration(ItemStack fuel)
    {
        Iterator<Entry<ItemStack, Integer>> iterator = this.fuelToTime.entrySet().iterator();
        Entry<ItemStack, Integer> entry;
        do
        {
            if(!iterator.hasNext())
            {
                return 0;
            }
            entry = iterator.next();
        }
        while(fuel.getItem() != entry.getKey().getItem() || fuel.getItemDamage() != entry.getKey().getItemDamage());

        return entry.getValue();
    }

    private void addFuel(ItemStack fuel, Integer time)
    {
        fuelToTime.put(fuel, time);
    }

    private void addRecipe(ItemStack[] input, ItemStack[] output)
    {
        if(input.length == TileEntitySecheLinge.INPUTS_SLOTS && output.length == TileEntitySecheLinge.OUTPUT_SLOTS)
        {
            inputToOutput.put(input, output);
        }
    }

    public ItemStack[] getRecipeResult(ItemStack[] input)
    {
        if(input.length != TileEntitySecheLinge.INPUTS_SLOTS)
            return null;

        Iterator<Entry<ItemStack[], ItemStack[]>> iterator = this.inputToOutput.entrySet().iterator();
        Entry<ItemStack[], ItemStack[]> entry;

        do
        {
            if(!iterator.hasNext())
            {
                return null;
            }
            entry = iterator.next();
        }
        while(!this.isSameKey(input, entry.getKey()));

        return entry.getValue();
    }

    private boolean isSameKey(ItemStack[] input, ItemStack[] entry)
    {
        for(int i = 0; i < input.length; i++)
        {
            if(input[i].getItem() != entry[i].getItem() || input[i].getItemDamage() != entry[i].getItemDamage())
                return false;
        }
        return true;
    }

}
