package com.CSC.net.block;

import java.util.Random;

import com.CSC.net.Main;
import com.CSC.net.GUI.ContainerCuve;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Blockcuve extends BlockContainer
{

    public int timer = 0;

    protected Blockcuve(Material materialIn)
    {
        super(materialIn);
        // TODO Auto-generated constructor stub
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ)
    {
        System.out.println("");
        if(world.isRemote)
        {
            return false;
        }
        else
        {
            player.openGui(Main.instance, 4, world, pos.getX(), pos.getY(), pos.getZ());
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state)
    {
        TileEntity tile = world.getTileEntity(pos);

        if(tile instanceof TileEntityCuve)
        {
            InventoryHelper.dropInventoryItems(world, pos, (TileEntityCuve)tile);
        }
        super.breakBlock(world, pos, state);
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta)
    {
        // TODO Auto-generated method stub
        return new TileEntityCuve();
    }

    @Override
    public int getRenderType()
    {
        return 3;
    }

}
