package com.CSC.net;

import java.io.IOException;

import org.apache.logging.log4j.Logger;

import com.CSC.net.Commands.Command1097;
import com.CSC.net.Commands.Command505;
import com.CSC.net.Commands.CommandAdministrer;
import com.CSC.net.Commands.CommandAffirmatif;
import com.CSC.net.Commands.CommandAhahah;
import com.CSC.net.Commands.CommandAntiCitoyen;
import com.CSC.net.Commands.CommandAppliquez;
import com.CSC.net.Commands.CommandArretez;
import com.CSC.net.Commands.CommandAvancez;
import com.CSC.net.Commands.CommandAvt1;
import com.CSC.net.Commands.CommandBloquez;
import com.CSC.net.Commands.CommandBougez;
import com.CSC.net.Commands.CommandCirculez1;
import com.CSC.net.Commands.CommandCirculez2;
import com.CSC.net.Commands.CommandCirculez3;
import com.CSC.net.Commands.CommandCitoyen;
import com.CSC.net.Commands.CommandCode100;
import com.CSC.net.Commands.CommandConfirmdata;
import com.CSC.net.Commands.CommandContinuez;
import com.CSC.net.Commands.CommandDcd;
import com.CSC.net.Commands.CommandDernierAvertissement;
import com.CSC.net.Commands.CommandDeuxiemeAvertissement;
import com.CSC.net.Commands.CommandDocumentez;
import com.CSC.net.Commands.CommandEmputez;
import com.CSC.net.Commands.CommandExaminez;
import com.CSC.net.Commands.CommandGrenade;
import com.CSC.net.Commands.CommandHostile;
import com.CSC.net.Commands.CommandInsecte;
import com.CSC.net.Commands.CommandIsolez;
import com.CSC.net.Commands.CommandMilice;
import com.CSC.net.Commands.CommandMort;
import com.CSC.net.Commands.CommandOkay;
import com.CSC.net.Commands.CommandPasUnGeste;
import com.CSC.net.Commands.CommandPassif;
import com.CSC.net.Commands.CommandPoursuivez;
import com.CSC.net.Commands.CommandPretEmputez;
import com.CSC.net.Commands.CommandRecu;
import com.CSC.net.Commands.CommandReculez;
import com.CSC.net.Commands.CommandReculez2;
import com.CSC.net.Commands.CommandRefusOptemperer;
import com.CSC.net.Commands.CommandRois;
import com.CSC.net.Commands.CommandSterilisez;
import com.CSC.net.Commands.CommandStop1;
import com.CSC.net.Commands.CommandTestLoyaute;
import com.CSC.net.Commands.CommandUnion;
import com.CSC.net.Commands.CommandVisuel;
import com.CSC.net.Commands.CommandVite;
import com.CSC.net.Events.Events;
import com.CSC.net.GUI.GuiHandler;
import com.CSC.net.packet.PacketBalai;
import com.CSC.net.packet.PacketGui;
import com.CSC.net.packet.PacketNameClient;
import com.CSC.net.packet.PacketNameServerAdd;
import com.CSC.net.packet.PacketNameServerRemove;
import com.CSC.net.packet.PacketSang;
import com.CSC.net.packet.PacketSounds;
import com.CSC.net.proxy.CommonProxy;
import com.CSC.net.save.WorldSaved;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Mod.EventHandler;
import net.minecraftforge.fml.common.Mod.Instance;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid = Main.MODID, version = Main.VERSION, name = "Cite Sous Controle")
public class Main
{
    public static final String MODID = "csc";
    public static final String VERSION = "1.0";

    public static SimpleNetworkWrapper network;

    @Instance(Main.MODID)
    public static Main instance;

    @SidedProxy(clientSide = "com.CSC.net.proxy.ClientProxy", serverSide = "com.CSC.net.proxy.ServerProxy")
    public static CommonProxy proxy;

    public static Logger logger;

    @EventHandler
    public void preinit(FMLPreInitializationEvent event) throws IOException
    {
        logger = event.getModLog();
        proxy.preInit(event.getSuggestedConfigurationFile());

        network = NetworkRegistry.INSTANCE.newSimpleChannel("csc:");
        network.registerMessage(PacketSang.Handler.class, PacketSang.class, 0, Side.CLIENT);
        network.registerMessage(PacketSounds.Handler.class, PacketSounds.class, 1, Side.CLIENT);
        network.registerMessage(PacketBalai.Handler.class, PacketBalai.class, 2, Side.SERVER);
        network.registerMessage(PacketNameClient.Handler.class, PacketNameClient.class, 3, Side.CLIENT);
        network.registerMessage(PacketNameServerAdd.Handler.class, PacketNameServerAdd.class, 4, Side.SERVER);
        network.registerMessage(PacketGui.Handler.class, PacketGui.class, 5, Side.CLIENT);
        network.registerMessage(PacketNameServerRemove.Handler.class, PacketNameServerRemove.class, 6, Side.SERVER);

    }

    @EventHandler
    public void init(FMLInitializationEvent event)
    {
        proxy.init();
        NetworkRegistry.INSTANCE.registerGuiHandler(instance, new GuiHandler());
        System.out.println("");

        // Events
        MinecraftForge.EVENT_BUS.register(new Events());
        FMLCommonHandler.instance().bus().register(new Events());

    }

    @EventHandler
    public void onServerStarting(FMLServerStartingEvent event)
    {
        event.registerServerCommand(new Command1097());
        event.registerServerCommand(new Command505());
        event.registerServerCommand(new CommandAdministrer());
        event.registerServerCommand(new CommandAffirmatif());
        event.registerServerCommand(new CommandAhahah());
        event.registerServerCommand(new CommandAntiCitoyen());
        event.registerServerCommand(new CommandAppliquez());
        event.registerServerCommand(new CommandArretez());
        event.registerServerCommand(new CommandAvancez());
        event.registerServerCommand(new CommandAvt1());
        event.registerServerCommand(new CommandBloquez());
        event.registerServerCommand(new CommandBougez());
        event.registerServerCommand(new CommandCirculez1());
        event.registerServerCommand(new CommandCirculez2());
        event.registerServerCommand(new CommandCirculez3());
        event.registerServerCommand(new CommandCitoyen());
        event.registerServerCommand(new CommandCode100());
        event.registerServerCommand(new CommandConfirmdata());
        event.registerServerCommand(new CommandContinuez());
        event.registerServerCommand(new CommandDcd());
        event.registerServerCommand(new CommandDernierAvertissement());
        event.registerServerCommand(new CommandDeuxiemeAvertissement());
        event.registerServerCommand(new CommandDocumentez());
        event.registerServerCommand(new CommandEmputez());
        event.registerServerCommand(new CommandExaminez());
        event.registerServerCommand(new CommandGrenade());
        event.registerServerCommand(new CommandHostile());
        event.registerServerCommand(new CommandInsecte());
        event.registerServerCommand(new CommandIsolez());
        event.registerServerCommand(new CommandMilice());
        event.registerServerCommand(new CommandMort());
        event.registerServerCommand(new CommandOkay());
        event.registerServerCommand(new CommandPassif());
        event.registerServerCommand(new CommandPasUnGeste());
        event.registerServerCommand(new CommandPoursuivez());
        event.registerServerCommand(new CommandPretEmputez());
        event.registerServerCommand(new CommandRecu());
        event.registerServerCommand(new CommandReculez());
        event.registerServerCommand(new CommandReculez2());
        event.registerServerCommand(new CommandRefusOptemperer());
        event.registerServerCommand(new CommandRois());
        event.registerServerCommand(new CommandSterilisez());
        event.registerServerCommand(new CommandStop1());
        event.registerServerCommand(new CommandTestLoyaute());
        event.registerServerCommand(new CommandUnion());
        event.registerServerCommand(new CommandVisuel());
        event.registerServerCommand(new CommandVite());

        WorldSaved.instance = WorldSaved.load();

    }

    @EventHandler
    public void postinit(FMLPostInitializationEvent event)
    {

    }
}
