package com.CSC.net.GUI;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;

import com.CSC.net.Main;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;

public class GuiMenuPrincipal extends GuiScreen
{

    private ResourceLocation ressource = new ResourceLocation("csc:textures/gui/MainMenu.png");

    private int closebutton;

    private int serveur;

    private int ts;

    private int mumble;

    private int SiteWeb;

    private int donation;

    private int forum;

    public GuiMenuPrincipal()
    {

    }

    @Override
    public void initGui()
    {

        closebutton = 0;

        serveur = 1;

        ts = 2;

        mumble = 3;

        SiteWeb = 4;

        donation = 5;

        forum = 6;

        this.buttonList.add(new BoutonCustom(closebutton, width / 2 - 123, 230, 40, 20, "�fRetour"));

        this.buttonList.add(new BoutonCustom(serveur, width / 2 - 105, 92, 64, 20, "�1Rejoindre Cit� Sous Contr�le"));

        this.buttonList.add(new BoutonCustom(ts, width / 2 - 105, 124, 64, 20, "�cTeamSpeak"));

        this.buttonList.add(new BoutonCustom(mumble, width / 2 - 102, 156, 64, 20, "�aMumble"));

        this.buttonList.add(new BoutonCustom(SiteWeb, width / 2 - 70, 230, 40, 20, "�fSite Web"));

        this.buttonList.add(new BoutonCustom(donation, width / 2 - 102, 156, 64, 20, "�aDonation"));

        this.buttonList.add(new BoutonCustom(forum, width / 2 - 102, 156, 64, 20, "�8Forum"));

        super.initGui();
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) throws IOException
    {
        super.keyTyped(typedChar, keyCode);
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException
    {

        switch(button.id)
        {
            case 0:
                break;
            case 1:
                FMLClientHandler.instance().connectToServerAtStartup("play.epicube.fr:", 25565);
                this.mc.thePlayer.closeScreen();
                break;
            case 2:
                if(Desktop.isDesktopSupported())
                { // Si on peut utiliser des URIs
                    try
                    {
                        Desktop.getDesktop().browse(new URI("ts3server://ts.minecraftforgefrance.fr?port=9987")); // On essaye de lancer TeamSpeak
                    }
                    catch(Exception e)
                    {
                        Main.logger.warn("Ouverture de teamspeak impossible", e);
                    }
                }
                this.mc.thePlayer.closeScreen();
                break;
            case 3:

                this.mc.thePlayer.closeScreen();
                break;
            case 4:
                URI uri = URI.create("http://cite-sous-controle.fr/");
                Desktop.getDesktop().browse(uri);
                break;
            case 5:
                URI uri2 = URI.create("http://cite-sous-controle.fr/don.htm");
                Desktop.getDesktop().browse(uri2);
                break;
            case 6:

                break;
            default:
                break;
        }

        super.actionPerformed(button);
    }

    @Override
    public void updateScreen()
    {
        super.updateScreen();
    }

    public void drawScreen(int mouseX, int mouseY, float partialTick)
    {

        mc.getTextureManager().bindTexture(ressource);

        this.drawTexturedModalRect(this.width / 2 - 135, this.height / 2 - 125, 0, 0, 256, 250);

        super.drawScreen(mouseX, mouseY, partialTick);
    }

    @Override
    public void onGuiClosed()
    {

    }

}