package com.CSC.net.GUI;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;

import org.lwjgl.opengl.GL11;

import com.CSC.net.Main;
import com.CSC.net.block.TileEntityMachineLaver;
import com.CSC.net.block.TileEntitySecheLinge;

public class GuiMachineLaver extends GuiContainer
{

    private static final ResourceLocation texture = new ResourceLocation(Main.MODID, "textures/gui/guiMachineLaver.png");
    private InventoryPlayer playerInv;
    private TileEntityMachineLaver tile;

    public GuiMachineLaver(TileEntityMachineLaver tile, InventoryPlayer inventory)
    {
        super(new ContainerMachineLaver(tile, inventory));
        this.playerInv = inventory;
        this.tile = tile;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY)
    {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        this.mc.getTextureManager().bindTexture(texture);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k - 14, l - 37, 0, 0, 210, 215);
        if(this.tile.isWorking())
        {
            this.drawTexturedModalRect(this.width / 2 - 10, l + 10, 214, 11, this.tile.getRecipeProgress(), 6);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int x, int y)
    {
        this.fontRendererObj.drawString(this.playerInv.hasCustomName() ? this.playerInv.getName() : I18n.format(this.playerInv.getName()), 8, this.ySize - 84, 4210752);
        this.fontRendererObj.drawString(this.tile.getName(), 49, -23, 4210752);
    }

}
