package com.CSC.net.GUI;

import java.io.IOException;

import com.CSC.net.Main;
import com.CSC.net.packet.PacketNameServerAdd;
import com.CSC.net.packet.PacketNameServerRemove;
import com.CSC.net.proxy.ServerProxy;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.EnumChatFormatting;

public class GuiJoinServer extends GuiScreen
{
    private boolean erreur;
    private int valider;

    private int nom;
    private int prenom;

    public GuiTextField text;
    public GuiTextField text2;

    public GuiJoinServer()
    {

    }

    @Override
    public void initGui()
    {
        valider = 0;
        nom = 1;
        prenom = 2;
        text = new GuiTextField(nom, fontRendererObj, width / 2, 130, 64, 20);
        text2 = new GuiTextField(prenom, fontRendererObj, width / 2, 100, 64, 20);
        text.setFocused(false);
        text2.setFocused(true);
        text.setMaxStringLength(20);
        text2.setMaxStringLength(20);
        this.buttonList.add(new GuiButton(valider, width / 2 - 123, 200, 40, 20, "Valider"));

        super.initGui();
    }

    @Override
    public void mouseClicked(int i, int j, int k)
    {
        text.mouseClicked(i, j, k);
        text2.mouseClicked(i, j, k);
        try
        {
            super.mouseClicked(i, j, k);
        }
        catch(IOException e)
        {
            e.printStackTrace();
        }
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) throws IOException
    {

        text.textboxKeyTyped(typedChar, keyCode);
        text2.textboxKeyTyped(typedChar, keyCode);
        super.keyTyped(typedChar, keyCode);
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException
    {

        switch(button.id)
        {
            case 0:
                if(!text.getText().equals("") && text.getText().length() > 3 && !text2.getText().equals("") && text2.getText().length() > 3 && !ServerProxy.map.containsKey(Minecraft.getMinecraft().getSession().getPlayerID()))
                {
                    // si les text ne sont pas vide et que il sont > que 3 arguments
                    // et que le joueur n'a pas de nom_prénom:
                    Main.network.sendToServer(new PacketNameServerAdd(text2.getText() + "_" + text.getText())); // ajoute le nouveau nom                                                                                                                      // la map
                    erreur = false;
                    mc.thePlayer.closeScreen();
                }
                else if(!text.getText().equals("") && text.getText().length() > 3 && !text2.getText().equals("") && text2.getText().length() > 3 && ServerProxy.map.containsKey(Minecraft.getMinecraft().getSession().getPlayerID()))
                {
                    // si les text ne sont pas vide et que il sont > que 3 arguments
                    // et que le joueur à déjà un nom_prénom:
                    Main.network.sendToServer(new PacketNameServerRemove());// retire l'ancient nom_prénom de la map
                    Main.network.sendToServer(new PacketNameServerAdd(text2.getText() + "_" + text.getText())); // ajoute le nouveau nom pr�nom dans la map
                    erreur = false;
                    mc.thePlayer.closeScreen();
                }
                else if(text.getText().equals("72") && !text2.getText().equals("") && text2.getText().length() > 3 && !ServerProxy.map.containsKey(Minecraft.getMinecraft().getSession().getPlayerID()))
                {
                    // Ici en gros c'est pour ne pas avoir de nom, juste un prénom,
                    // le joueur met 72 dans le champ nom pour ne pas avoir de nom.
                    Main.network.sendToServer(new PacketNameServerAdd(text2.getText())); // ....
                    erreur = false;
                    mc.thePlayer.closeScreen();
                }
                else if(text.getText().equals("72") && !text2.getText().equals("") && text2.getText().length() > 3 && ServerProxy.map.containsKey(Minecraft.getMinecraft().getSession().getPlayerID()))
                {
                    Main.network.sendToServer(new PacketNameServerRemove());// ....
                    Main.network.sendToServer(new PacketNameServerAdd(text2.getText()));// ....
                    erreur = false;
                    mc.thePlayer.closeScreen();
                }
                else
                {
                    erreur = true;
                }
                break;
            default:
                erreur = false;
                break;
        }

        super.actionPerformed(button);
    }

    @Override
    public void updateScreen()
    {
        super.updateScreen();
    }

    public void drawScreen(int mouseX, int mouseY, float partialTick)
    {

        this.drawDefaultBackground();

        text.drawTextBox();
        text2.drawTextBox();

        this.drawString(this.fontRendererObj, EnumChatFormatting.GRAY + "Nom", width / 2 - 80, 135, 0);

        this.drawString(this.fontRendererObj, EnumChatFormatting.GRAY + "Prénom", width / 2 - 80, 105, 0);

        super.drawScreen(mouseX, mouseY, partialTick);

        if(erreur)
        {
            this.drawString(fontRendererObj, "§cVotre nom et/ou pr�nom est/sont vide ou trop court !", this.width / 2 - 110, this.height / 2 - 50, 0);
        }
    }

    @Override
    public void onGuiClosed()
    {
        Minecraft.getMinecraft().displayGuiScreen(this);
    }
}
