package com.CSC.net.GUI;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

import com.CSC.net.block.TileEntityCuve;
import com.CSC.net.block.TileEntityMachineLaver;
import com.CSC.net.block.TileEntitySecheLinge;

public class GuiHandler implements IGuiHandler
{

    public static EntityPlayer currentTarget;

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
    {
        if(ID == 0)
        {
            return new ContainerLinge(player.inventory, new InventoryLinge(player.getHeldItem(), 54));
        }
        if(ID == 1)
        {
            return new ContainerPlayerCustom(currentTarget.inventory, world.isRemote, currentTarget);
        }
        if(ID == 2)
        {
            TileEntity tile = world.getTileEntity(new BlockPos(x, y, z));

            if(tile instanceof TileEntitySecheLinge)
            {
                return new ContainerSecheLinge((TileEntitySecheLinge)tile, player.inventory);
            }
        }
        if(ID == 3)
        {
            return new ContainerColi(player.inventory, new InventoryColi(player.getHeldItem(), 54));
        }
        if(ID == 4)
        {
            TileEntity te = world.getTileEntity(new BlockPos(x, y, z));
            if(te instanceof TileEntityCuve)
            {
                return new ContainerCuve(player.inventory, (TileEntityCuve)te);
            }
            return null;
        }
        if(ID == 5)
        {
            TileEntity tile = world.getTileEntity(new BlockPos(x, y, z));

            if(tile instanceof TileEntityMachineLaver)
            {
                return new ContainerMachineLaver((TileEntityMachineLaver)tile, player.inventory);
            }
            if(ID == 6)
            {
                return null;
            }
        }
        return null;
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
    {
        if(ID == 0)
        {
            return new GuiLinge(player.inventory, new InventoryLinge(player.getHeldItem(), 54));
        }
        if(ID == 1)
        {
            return new GuiInv(currentTarget);
        }
        if(ID == 2)
        {
            TileEntity tile = world.getTileEntity(new BlockPos(x, y, z));

            if(tile instanceof TileEntitySecheLinge)
            {
                return new GuiSecheLinge((TileEntitySecheLinge)tile, player.inventory);
            }
        }
        if(ID == 3)
        {
            return new GuiColi(player.inventory, new InventoryColi(player.getHeldItem(), 54));
        }
        if(ID == 4)
        {
            TileEntity te = world.getTileEntity(new BlockPos(x, y, z));
            if(te instanceof TileEntityCuve)
            {
                return new GuiCuve(player.inventory, (TileEntityCuve)te);
            }
            return null;
        }
        if(ID == 5)
        {
            TileEntity tile = world.getTileEntity(new BlockPos(x, y, z));

            if(tile instanceof TileEntityMachineLaver)
            {
                return new GuiMachineLaver((TileEntityMachineLaver)tile, player.inventory);
            }
            if(ID == 6)
            {
                return new Prison();
            }
        }
        return null;
    }

}
