package com.CSC.net.GUI;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

import org.lwjgl.opengl.GL11;

import com.CSC.net.block.TileEntityCuve;

public class GuiCuve extends GuiContainer
{
    public static ResourceLocation texture = new ResourceLocation("csc:textures/gui/generic_54.png");// texture de grand coffre
    private TileEntityCuve bigChest;
    private IInventory playerInventory;

    public GuiCuve(InventoryPlayer inventory, TileEntityCuve tileEntity)
    {
        super(new ContainerCuve(inventory, tileEntity));
        this.bigChest = tileEntity;
        this.playerInventory = inventory;
        this.ySize = 230;
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2)
    {
        this.fontRendererObj.drawString(this.playerInventory.hasCustomName() ? this.playerInventory.getName() : I18n.format(this.playerInventory.getName()), 8, 73, 0);
        this.fontRendererObj.drawString(this.bigChest.isInvNameLocalized() ? this.bigChest.getName() : I18n.format(this.bigChest.getName()), 8, 6, 0);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j)
    {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        this.mc.getTextureManager().bindTexture(texture);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
    }
}