package com.CSC.net.GUI;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import com.CSC.net.block.TileEntityMachineLaver;

public class ContainerMachineLaver extends Container
{

    private TileEntityMachineLaver tile;
    private int currentWorkingTime;
    private int totalWorkingTime;
    private int remainingFuelTime;

    public ContainerMachineLaver(TileEntityMachineLaver tile, InventoryPlayer inventory)
    {
        this.tile = tile;

        // INPUTS
        this.addSlotToContainer(new Slotlingesale(tile, 0, 4, 5));
        this.addSlotToContainer(new Slotlingesale(tile, 1, 28, 30));
        this.addSlotToContainer(new Slotlingesale(tile, 2, 52, 5));
        this.addSlotToContainer(new Slotlingesale(tile, 3, 28, -20));

        // FUEL
        this.addSlotToContainer(new Slotlessive(tile, 4, 28, 5));

        // OUTPUTS
        this.addSlotToContainer(new SlotOutput(tile, 5, 107, 5));
        this.addSlotToContainer(new SlotOutput(tile, 6, 155, 5));
        this.addSlotToContainer(new SlotOutput(tile, 7, 131, -20));
        this.addSlotToContainer(new SlotOutput(tile, 8, 131, 30));

        this.bindPlayerInventory(inventory);
    }

    private void bindPlayerInventory(InventoryPlayer inventory)
    {
        int i;
        int j;
        for(i = 0; i < 3; ++i)
        {
            for(j = 0; j < 9; ++j)
            {
                this.addSlotToContainer(new Slot(inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + 12));
            }
        }

        for(i = 0; i < 9; ++i)
        {
            this.addSlotToContainer(new Slot(inventory, i, 8 + i * 18, 142 + 12));
        }
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, int quantity)
    {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.inventorySlots.get(quantity);
        if(slot != null && slot.getHasStack())
        {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if(quantity < this.tile.getSizeInventory())
            {
                if(!this.mergeItemStack(itemstack1, this.tile.getSizeInventory(), this.inventorySlots.size(), true))
                {
                    return null;
                }
            }
            else if(!this.mergeItemStack(itemstack1, 0, this.tile.getSizeInventory(), false))
            {
                return null;
            }
            if(itemstack1.stackSize == 0)
            {
                slot.putStack((ItemStack)null);
            }
            else
            {
                slot.onSlotChanged();
            }
        }
        return itemstack;
    }

    @Override
    public boolean canInteractWith(EntityPlayer player)
    {
        return this.tile.isUseableByPlayer(player);
    }

    @Override
    public void onContainerClosed(EntityPlayer player)
    {
        super.onContainerClosed(player);
        this.tile.closeInventory(player);
    }

    @Override
    public void onCraftGuiOpened(ICrafting crafting)
    {
        super.onCraftGuiOpened(crafting);
        for(int i = 0; i < this.tile.getFieldCount(); i++)
        {
            crafting.sendProgressBarUpdate(this, i, this.tile.getField(i));
        }
        crafting.sendAllWindowProperties(this, this.tile);
    }

    @Override
    public void detectAndSendChanges()
    {
        super.detectAndSendChanges();
        for(int i = 0; i < this.crafters.size(); ++i)
        {
            ICrafting icrafting = (ICrafting)this.crafters.get(i);
            for(int j = 0; j < this.tile.getFieldCount(); j++)
            {
                if(this.getField(j) != this.tile.getField(j))
                {
                    icrafting.sendProgressBarUpdate(this, j, this.tile.getField(j));
                }
            }
        }
        for(int i = 0; i < this.tile.getFieldCount(); i++)
        {
            this.setField(i, this.tile.getField(i));
        }
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void updateProgressBar(int id, int value)
    {
        this.tile.setField(id, value);
    }

    private int getField(int id)
    {
        switch(id)
        {
            case 0:
                return this.currentWorkingTime;
            case 1:
                return this.totalWorkingTime;
            case 2:
                return this.remainingFuelTime;
            default:
                return 0;
        }
    }

    private void setField(int id, int value)
    {
        switch(id)
        {
            case 0:
                this.currentWorkingTime = value;
                break;
            case 1:
                this.totalWorkingTime = value;
                break;
            case 2:
                this.remainingFuelTime = value;
        }
    }

}
