package com.CSC.net.Events;

import java.util.List;

import net.minecraft.block.BlockDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent.Action;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.BlockEvent.BreakEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import com.CSC.net.Main;
import com.CSC.net.GUI.GuiJoinServer;
import com.CSC.net.GUI.PrenomGui;
import com.CSC.net.item.CSCItems;
import com.CSC.net.packet.PacketGui;
import com.CSC.net.packet.PacketNameServerAdd;
import com.CSC.net.packet.PacketSang;
import com.CSC.net.proxy.ServerProxy;
import com.CSC.net.save.WorldSaved;
import com.google.common.collect.Lists;

public class Events
{
    @SideOnly(Side.CLIENT)
    @SubscribeEvent
    public void onHit(LivingHurtEvent event)
    {
        if(event.entityLiving instanceof EntityPlayer)
        {
            System.out.println("eventhurt");
            Main.network.sendTo(new PacketSang(), (EntityPlayerMP)event.entityLiving);
        }
    }

    public static String Key = "key";

    public static ItemStack items;

    public static Position p1;

    public static final List<Position> doorsPositions = Lists.newArrayList();

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent e)
    {
        if(!e.world.isRemote)
        {
            ItemStack stack = e.entityPlayer.getHeldItem();
            if(stack != null && stack.getItem() == CSCItems.clef && e.action == Action.RIGHT_CLICK_BLOCK)
            {
                BlockPos pos = e.pos;
                IBlockState state = e.world.getBlockState(pos);
                items = stack;
                if(state.getBlock() == Blocks.iron_door)
                {
                    /**
                     * On se base sur la partie haute de la porte, en effet c'est cette partie qui contient
                     * l'information pour savoir si la porte est ouverte ou non.
                     * Ici si c'est la partie basse on ajoute 1 � la coordonn�e Y et on r�cup�re donc l'�tat
                     * de la partie haute.
                     */
                    if(state.getValue(BlockDoor.HALF) == BlockDoor.EnumDoorHalf.LOWER)
                    {
                        pos = pos.up();
                        state = e.world.getBlockState(pos);
                    }
                    /**
                     * Si c'est une nouvelle cl� on �crit les coordonn�e de la porte ainsi que l'id
                     * de la dimension dans ses tag NBT.
                     */
                    if(!stack.hasTagCompound())
                    {
                        Position p = new Position(pos, e.world.provider.getDimensionId());
                        p1 = p;
                        if(!doorsPositions.contains(p))
                        {
                            NBTTagCompound nbt = new NBTTagCompound();
                            nbt.setIntArray("doorPos", new int[] {e.world.provider.getDimensionId(), pos.getX(), pos.getY(), pos.getZ()});
                            stack.setTagCompound(nbt);
                            doorsPositions.add(new Position(pos.getX(), pos.getY(), pos.getZ(), e.world.provider.getDimensionId()));
                            e.entityPlayer.addChatComponentMessage(new ChatComponentText(EnumChatFormatting.GREEN + "Tu as cr�� une cl�"));
                            WorldSaved.instance.markDirty();
                        }
                        else
                        {
                            e.entityPlayer.addChatComponentMessage(new ChatComponentText(EnumChatFormatting.RED + "Une cl� existe d�j� pour cette porte"));
                        }
                    }
                    /**
                     * Ici tu peut enlever le else ce qui aura pour effet d'ouvrir la porte lors de la cr�ation
                     * de la cl� car avec le else on doit cr�er la porte et refaire clique droit pour l'ouvrir.
                     */
                    else
                    {
                        int[] doorPos = stack.getTagCompound().getIntArray("doorPos");
                        if(doorPos[0] == e.world.provider.getDimensionId() && doorPos[1] == pos.getX() && doorPos[2] == pos.getY() && doorPos[3] == pos.getZ())
                        {
                            Boolean opened = (Boolean)(state.getValue(BlockDoor.POWERED));
                            /**
                             * Il y a d'autres solutions pour garder la porte ouverte, j'avais essayé de changé le state en POWERED = true
                             * à chaque tick mais en changeant l'état ça update le bloc remettant POWERED à false
                             * donc il faut obligatoirement utiliser la redstone, par contre tu peux faire que la
                             * porte doit être posée sur un certain bloc (que tu va cr�er) et qui alimentera ou pas la
                             * porte en �nergie, ça sera plus propre que la torche. C'est � toi de voir.
                             */
                            if(opened)
                            {
                                e.world.setBlockToAir(pos.down(3));
                            }
                            else
                            {
                                e.world.setBlockState(pos.down(3), Blocks.redstone_torch.getDefaultState());
                            }
                            e.entityPlayer.addChatComponentMessage(new ChatComponentText(EnumChatFormatting.GREEN + "Tu as" + (opened ? " ferm� " : " ouvert ") + "la porte"));
                        }
                        else
                        {
                            e.entityPlayer.addChatComponentMessage(new ChatComponentText(EnumChatFormatting.RED + "Ceci n'est pas la bonne cl�"));
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event)
    {
        /**
         * On supprime la porte de la liste si on la casse.
         */
        if(event.state.getBlock() == Blocks.iron_door)
        {
            BlockPos pos = event.pos;
            if(event.state.getValue(BlockDoor.HALF) == BlockDoor.EnumDoorHalf.LOWER)
            {
                pos = pos.up();
            }
            Position p = new Position(pos, event.world.provider.getDimensionId());
            doorsPositions.remove(p);
            WorldSaved.instance.markDirty();
            System.out.println("");
        }
    }

    /**
     * On cr�e un objet pour stocker la position + l'id de la dimension
     */
    public static class Position extends BlockPos
    {
        public int dimensionId;

        public Position(double x, double y, double z, int dimension)
        {
            super(x, y, z);
            this.dimensionId = dimension;
        }

        public Position(BlockPos pos, int dimension)
        {
            super(pos);
            this.dimensionId = dimension;
        }

        @Override
        public boolean equals(Object o)
        {
            if(o instanceof Position)
            {
                Position pos = (Position)o;
                if(super.equals(o) && pos.dimensionId == this.dimensionId)
                {
                    return true;
                }
            }
            return false;
        }
    }

    @SubscribeEvent
    public void onTimerPrison(TickEvent.WorldTickEvent event)
    {

    }

    @SideOnly(Side.CLIENT)
    @SubscribeEvent
    public void renderGameOverlayEvent(RenderGameOverlayEvent.Pre event)
    {
        String str;
        Minecraft mc = Minecraft.getMinecraft();
        int i = event.resolution.getScaledWidth();
        int i2 = event.resolution.getScaledWidth() + 8;
        int j = event.resolution.getScaledHeight() - 80;
        int j2 = event.resolution.getScaledHeight() - 100;
        int j3 = event.resolution.getScaledHeight() - 60;
        int j4 = event.resolution.getScaledHeight() - 120;
        int j5 = event.resolution.getScaledHeight() - 40;

        ItemStack head = ((EntityPlayer)mc.thePlayer).inventory.armorInventory[3];

        if(event.type == RenderGameOverlayEvent.ElementType.TEXT)
        {
            str = EnumChatFormatting.WHITE + String.valueOf(mc.thePlayer.getFoodStats().getFoodLevel() * 5);
            mc.fontRendererObj.drawString(str, i - Minecraft.getMinecraft().fontRendererObj.getStringWidth(str), j, 0);

            str = EnumChatFormatting.WHITE + String.valueOf(mc.thePlayer.getHealth() * 5);
            mc.fontRendererObj.drawString(str, i2 - Minecraft.getMinecraft().fontRendererObj.getStringWidth(str), j2, 0);

            str = EnumChatFormatting.WHITE + String.valueOf(mc.thePlayer.inventory.getTotalArmorValue() * 5);
            mc.fontRendererObj.drawString(str, i - Minecraft.getMinecraft().fontRendererObj.getStringWidth(str), j3, 0);

            str = EnumChatFormatting.WHITE + String.valueOf(mc.thePlayer.getDisplayName().getUnformattedText());
            mc.fontRendererObj.drawString(str, i - Minecraft.getMinecraft().fontRendererObj.getStringWidth(str), j5, 0);

            if(head != null)
            {
                int posX = event.resolution.getScaledWidth() / 5 - 76;
                int posY = event.resolution.getScaledHeight() / 3 - 80;
                mc.renderEngine.bindTexture(new ResourceLocation("csc:textures/gui/armor_icons.png"));
                mc.ingameGUI.drawTexturedModalRect(posX, posY, 0, 0, 16, 14);
            }

            mc.renderEngine.bindTexture(new ResourceLocation("csc:textures/gui/arma_icons.png"));

            int posX = event.resolution.getScaledWidth() - 45;
            int posY = event.resolution.getScaledHeight() - 86;
            mc.ingameGUI.drawTexturedModalRect(posX, posY, 0, 0, 16, 16);

            posX = event.resolution.getScaledWidth() - 45;
            posY = event.resolution.getScaledHeight() - 105;
            mc.ingameGUI.drawTexturedModalRect(posX, posY, 16, 0, 16, 16);

            posX = event.resolution.getScaledWidth() - 45;
            posY = event.resolution.getScaledHeight() - 66;
            mc.ingameGUI.drawTexturedModalRect(posX, posY, 32, 0, 16, 16);

        }
    }

    @SubscribeEvent
    public void onInteract2(PlayerInteractEvent e)
    {
        if(!e.world.isRemote)
        {
            ItemStack stack = e.entityPlayer.getHeldItem();
            if(stack != null && stack.getItem() == CSCItems.belier | stack.getItem() == CSCItems.clef_combine && e.action == Action.RIGHT_CLICK_BLOCK)
            {
                BlockPos pos = e.pos;
                IBlockState state = e.world.getBlockState(pos);
                Boolean opened = (Boolean)(state.getValue(BlockDoor.POWERED));
                if(state.getBlock() == Blocks.iron_door)
                {
                    /**
                     * On se base sur la partie haute de la porte, en effet c'est cette partie qui contient
                     * l'information pour savoir si la porte est ouverte ou non.
                     * Ici si c'est la partie basse on ajoute 1 � la coordonn�e Y et on r�cup�re donc l'�tat
                     * de la partie haute.
                     */
                    if(state.getValue(BlockDoor.HALF) == BlockDoor.EnumDoorHalf.LOWER)
                    {
                        pos = pos.up();
                        state = e.world.getBlockState(pos);
                    }
                    if(!opened)
                    {
                        e.world.setBlockState(pos.down(3), Blocks.redstone_torch.getDefaultState());

                        e.entityPlayer.addChatComponentMessage(new ChatComponentText(EnumChatFormatting.GREEN + "Vous avez enfonc� cette porte !"));
                    }
                    else
                    {
                        e.entityPlayer.addChatComponentMessage(new ChatComponentText(EnumChatFormatting.RED + "Porte d�j� enfonc�!"));
                    }
                }

            }
        }
    }

    @SubscribeEvent
    public void onDeco(net.minecraftforge.fml.common.gameevent.PlayerEvent.PlayerLoggedOutEvent event)
    {
        if(doorsPositions.contains(p1))
        {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.removeTag("doorPos");
            items.setTagCompound(nbt);
            doorsPositions.remove(p1);
            WorldSaved.instance.markDirty();

        }
    }

    // @SubscribeEvent
    // public void onInteract3(PlayerInteractEvent e) {
    // if(!e.world.isRemote) {
    // ItemStack stack = e.entityPlayer.getHeldItem();
    // if(stack != null && stack.getItem() == CSCItems.balai && e.action == Action.RIGHT_CLICK_BLOCK) {
    // BlockPos pos = e.pos;
    // IBlockState state = e.world.getBlockState(pos);
    // if(state.getBlock() == Blocks.bedrock && e.world.getBlockState(new BlockPos(pos.getX(), pos.getY() + 1, pos.getZ())).getBlock() != Blocks.anvil) {
    //
    // e.world.setBlockState(new BlockPos(pos.getX(), pos.getY(), pos.getZ()), CSCBlocks.block1.getDefaultState());
    //
    // }
    // else
    // {
    // e.entityPlayer.addChatMessage(new ChatComponentText(EnumChatFormatting.RED + "Vous ne pouvez pas n�ttoyez ce bloc car il y a une poubelle dessus, enlevez d'abord la poubelle avant de n�ttoyer
    // ce bloc"));
    // }
    // }
    // }
    //
    // }
    @SubscribeEvent
    public void changedisplayname(PlayerEvent.NameFormat e)
    {
        if(ServerProxy.map.containsKey(e.entityPlayer.getGameProfile().getId()))
        {
            e.displayname = ServerProxy.map.get(e.entityPlayer.getGameProfile().getId());
        }
    }

    @SubscribeEvent
    public void onconnection(net.minecraftforge.fml.common.gameevent.PlayerEvent.PlayerLoggedInEvent e)
    {
        EntityPlayerMP playermp = (EntityPlayerMP)e.player;
        if(!ServerProxy.map.containsKey(playermp.getGameProfile().getId()))
        {
            Main.network.sendTo(new PacketGui(), playermp);
        }
    }

    @SideOnly(Side.CLIENT)
    @SubscribeEvent
    public void onRenderLabel(RenderLivingEvent.Specials.Pre event)
    {
        if(event.entity instanceof EntityPlayer)
        {
            EntityPlayer player = (EntityPlayer)event.entity;
            if(Minecraft.getMinecraft().thePlayer.getPosition().distanceSq(player.posX, player.posY, player.posZ) > 12)
            {
                event.setCanceled(true);
            }
        }
    }

    // @SubscribeEvent
    // public void onBreakBlock(BlockEvent.BreakEvent event)
    // {
    // BlockPos pos = event.pos;
    // IBlockState state = event.state;
    //
    // if(state.getBlock() == Blocks.iron_door)
    // {
    //
    // }
    // }

}