/*
 * Decompiled with CFR 0.152.
 */
package elx9000.survivant.tileEntity;

import elx9000.survivant.blocks.BlockMod;
import elx9000.survivant.recipe.RecipesCampfire;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCampfire
extends TileEntity
implements IInventory,
ITickable {
    private String customName;
    public static final int INPUTS_SLOTS = 1;
    public static final int FUEL_SLOTS = 1;
    public static final int OUTPUT_SLOTS = 1;
    private NonNullList<ItemStack> contents = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int currentWorkingTime = 0;
    private int totalWorkingTime = 300;
    private float remainingFuelTime = 8.0f;
    private int i = 0;

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.contents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.contents);
        this.currentWorkingTime = compound.func_74762_e("CurrentWorkingTime");
        this.totalWorkingTime = compound.func_74762_e("TotalWorkingTime");
        this.remainingFuelTime = compound.func_74760_g("RemainingFuelTime");
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("CurrentWorkingTime", this.currentWorkingTime);
        compound.func_74768_a("TotalWorkingTime", this.totalWorkingTime);
        compound.func_74776_a("RemainingFuelTime", this.remainingFuelTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.contents);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.campfire";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public int func_70302_i_() {
        return this.contents.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.contents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.contents.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.contents, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.contents, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemStack = (ItemStack)this.contents.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemStack);
        this.contents.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index >= 2 ? false : index < 1 || this.isFuel(stack);
    }

    private boolean isFuel(ItemStack stack) {
        return stack == null ? false : stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150364_r) || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150344_f);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.currentWorkingTime;
            }
            case 1: {
                return this.totalWorkingTime;
            }
            case 2: {
                return (int)this.remainingFuelTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.currentWorkingTime = value;
                break;
            }
            case 1: {
                this.totalWorkingTime = value;
                break;
            }
            case 2: {
                this.remainingFuelTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        this.contents.clear();
    }

    private ItemStack[] getInputSlotsContents() {
        ItemStack[] s = new ItemStack[1];
        for (int i = 0; i < 1; ++i) {
            s[i] = this.func_70301_a(i);
        }
        return s;
    }

    private ItemStack[] getOutputSlotsContents() {
        ItemStack[] s = new ItemStack[1];
        int k = 0;
        for (int i = 2; i < 3; ++i) {
            s[k] = this.func_70301_a(i);
            ++k;
        }
        return s;
    }

    public boolean isWorking() {
        return this.remainingFuelTime > 0.0f;
    }

    private boolean hasNullInput() {
        for (int i = 0; i < 1; ++i) {
            if (this.func_70301_a(i) != null) continue;
            return true;
        }
        return false;
    }

    private boolean areOutputsNull() {
        for (int i = 2; i < 3; ++i) {
            if (this.func_70301_a(i) == null) continue;
            return false;
        }
        return true;
    }

    private boolean canCombineStacks(ItemStack[] stack1, ItemStack[] stack2) {
        if (stack1.length != stack2.length) {
            return false;
        }
        for (int i = 0; i < stack1.length; ++i) {
            if (this.canCombineItems(stack1[i], stack2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean canCombineItems(ItemStack item1, ItemStack item2) {
        if (item1 == null) {
            return true;
        }
        if (!item1.func_77969_a(item2)) {
            return false;
        }
        int result = item1.func_77976_d() + item2.func_77976_d();
        return result <= this.func_70297_j_() && result <= item1.func_77976_d();
    }

    private boolean outOfFuel() {
        if (!this.isRemainingFuel()) {
            for (int i = 1; i < 2; ++i) {
                int duration;
                if (this.func_70301_a(i) == null || (duration = this.getFuelDuration(this.func_70301_a(i))) <= 0) continue;
                this.remainingFuelTime = duration;
                this.func_70298_a(i, 1);
            }
        }
        this.func_70296_d();
        return !this.isRemainingFuel();
    }

    private boolean fuelIsHere() {
        this.func_70296_d();
        return !this.func_70301_a(1).func_190926_b();
    }

    public boolean isRemainingFuel() {
        return this.remainingFuelTime > 2.0f;
    }

    private boolean canWork() {
        if (((ItemStack)this.contents.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemStack = RecipesCampfire.instance().getRecipeResult((ItemStack)this.contents.get(0));
        if (itemStack.func_190926_b()) {
            return false;
        }
        ItemStack itemStack1 = (ItemStack)this.contents.get(2);
        if (itemStack1.func_190926_b()) {
            return true;
        }
        if (!itemStack1.func_77969_a(itemStack)) {
            return false;
        }
        if (itemStack1.func_190916_E() + itemStack.func_190916_E() <= this.func_70297_j_() && itemStack1.func_190916_E() + itemStack.func_190916_E() <= itemStack1.func_77976_d()) {
            return true;
        }
        return itemStack1.func_190916_E() + itemStack.func_190916_E() <= itemStack.func_77976_d();
    }

    private void applyRecipe() {
        if (this.canWork()) {
            ItemStack currentSmeltingItem = (ItemStack)this.contents.get(0);
            ItemStack resultItem = RecipesCampfire.instance().getRecipeResult(currentSmeltingItem);
            ItemStack currentFuturItem = (ItemStack)this.contents.get(2);
            if (currentFuturItem.func_190926_b()) {
                this.contents.set(2, (Object)resultItem.func_77946_l());
            } else if (currentFuturItem.func_77973_b() == resultItem.func_77973_b()) {
                currentFuturItem.func_190917_f(resultItem.func_190916_E());
            }
            currentSmeltingItem.func_190918_g(1);
        }
    }

    public void func_73660_a() {
        if (this.isRemainingFuel()) {
            this.remainingFuelTime -= 0.01f;
        }
        if (!this.isRemainingFuel()) {
            this.remainingFuelTime = 1.0f;
            this.field_145850_b.func_175656_a(this.field_174879_c, BlockMod.campfire.func_176223_P());
        }
        if (this.isWorking() && this.canWork()) {
            ++this.currentWorkingTime;
            this.remainingFuelTime -= 0.01f;
        }
        if (!this.isWorking() && this.canWork()) {
            this.currentWorkingTime = 1;
        }
        if (this.canWork() && this.currentWorkingTime >= this.totalWorkingTime) {
            this.applyRecipe();
            this.currentWorkingTime = 0;
        }
        if (!this.canWork()) {
            this.currentWorkingTime = 0;
        }
        if (this.fuelIsHere()) {
            int duration = this.getFuelDuration(this.func_70301_a(1));
            this.remainingFuelTime = this.remainingFuelTime <= 88.0f ? (this.remainingFuelTime += (float)duration) : (this.remainingFuelTime += 108.0f - this.remainingFuelTime);
            this.func_70298_a(1, 1);
        }
        this.func_70296_d();
    }

    public int getFuelDuration(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == Item.func_150898_a((Block)Blocks.field_150364_r)) {
            return 20;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150363_s)) {
            return 20;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150344_f)) {
            return 5;
        }
        return 0;
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_189515_b(nbttagcompound);
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    @SideOnly(value=Side.CLIENT)
    public int getRecipeProgress() {
        return this.currentWorkingTime * 24 / this.totalWorkingTime;
    }
}

