/*
 * Decompiled with CFR 0.152.
 */
package elx9000.survivant.recipe;

import com.google.common.collect.Maps;
import elx9000.survivant.tileEntity.TileEntityCampfire;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;

public class RecipesCampfire {
    private static final RecipesCampfire INSTANCE = new RecipesCampfire();
    private final Map<ItemStack, ItemStack> smeltingList = Maps.newHashMap();
    private TileEntityCampfire tile;

    public static RecipesCampfire instance() {
        return INSTANCE;
    }

    public void addRecipeForBlock(Block input, ItemStack stack) {
        this.addSmelting(Item.func_150898_a((Block)input), stack);
    }

    public void addSmelting(Item input, ItemStack stack) {
        this.addSmeltingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack);
    }

    public void addSmeltingRecipe(ItemStack input, ItemStack stack) {
        if (this.getRecipeResult(input) != ItemStack.field_190927_a) {
            FMLLog.log.info("Ignored smelting recipe with conflicting input: {} = {}", (Object)input, (Object)stack);
            return;
        }
        this.smeltingList.put(input, stack);
    }

    public ItemStack getRecipeResult(ItemStack input) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.smeltingList.entrySet()) {
            if (!this.compareItemStacks(input, entry.getKey())) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    private RecipesCampfire() {
        for (ItemFishFood.FishType itemfishfood$fishtype : ItemFishFood.FishType.values()) {
            if (!itemfishfood$fishtype.func_150973_i()) continue;
            this.addSmeltingRecipe(new ItemStack(Items.field_151115_aP, 1, itemfishfood$fishtype.func_150976_a()), new ItemStack(Items.field_179566_aV, 1, itemfishfood$fishtype.func_150976_a()));
        }
    }
}

