/*
 * Decompiled with CFR 0.152.
 */
package fr.eyzox.ticklinkedlist;

import fr.eyzox.ticklinkedlist.TickContainer;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class AbstractTickContainerLinkedList<T> {
    protected LinkedList<TickContainer<T>> list = new LinkedList();

    public T tick() {
        if (this.list.isEmpty()) {
            return null;
        }
        TickContainer<T> tc = this.list.getFirst();
        tc.tick();
        if (tc.isExpired()) {
            return this.list.poll().getData();
        }
        return null;
    }

    public void add(int tick, T data) {
        this.add(new TickContainer<T>(tick, data));
    }

    protected void add(TickContainer<T> tickContainerToAdd) {
        if (this.list.isEmpty()) {
            this.list.add(tickContainerToAdd);
        } else {
            ListIterator<TickContainer> it = this.list.listIterator();
            while (it.hasNext()) {
                TickContainer current = (TickContainer)it.next();
                int compareResult = current.compareTo(tickContainerToAdd);
                if (compareResult < 0) {
                    tickContainerToAdd.decrease(current);
                    continue;
                }
                if (compareResult == 0) {
                    current.setData(this.merge(tickContainerToAdd.getData(), current.getData()));
                    return;
                }
                it.set(tickContainerToAdd);
                current.decrease(tickContainerToAdd);
                it.add(current);
                return;
            }
            this.list.add(tickContainerToAdd);
        }
    }

    protected abstract T merge(T var1, T var2);
}

